#include <stdio.h>

static FILE *fa;

static void do_sprite_routines(char *t, int x)
{
	int i, j, count;
	for (i = 0; i < 0x100; i++) {
		fprintf (fa, "static void sprdraw%s_%2.2x(unsigned short *%s, unsigned char *%s)\n{\n", t, i, (!i)?"":"dst", (!i)?"":"src");
		for (count = j = 0; j < 8; j++) {
			if (i & (1 << j)) {
				fprintf (fa, "\tdst[%s%d] = pgm_spr_pal[src[%d]];\n", ((x && j == 0)||(!x)) ? " " : "", (x) ? (0 - j) : j, count);
				count++;
			}
		}
		fprintf (fa, "}\n\n");
	}
}

static void do_pointer_table(char *t0, char *t1)
{
	int i;

	for (i = 0; i < 0x100; i++) {
		if ((i & 0x07)==0x00) fprintf (fa, "\t\t");
		fprintf (fa, "&sprdraw%s_%2.2x", t1, i);
		if (i != 0xff) fprintf (fa, ",");
		if ((i & 0x07)!=0x07) fprintf (fa, " ");
		if ((i & 0x07)==0x07) fprintf (fa, "\n");
	}
}

int main()
{
	fa = fopen("pgm_sprite.h", "wt");

	fprintf (fa, "typedef void (*sprite_draw_function)(unsigned short *, unsigned char *);\n\n");

	do_sprite_routines("n", 0);
	do_sprite_routines("f", 1);

	fprintf (fa, "\n\nstatic sprite_draw_function sprite_functions[2][0x100] =\n{\n\t{\n");

	do_pointer_table("",          "n");
	fprintf (fa, "\t},\n\t{\n");
	do_pointer_table("_flipped",  "f");
	fprintf (fa, "\t}\n};\n");
	fclose (fa);
}
